/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.util;

import java.util.function.IntFunction;
import mod.traister101.sns.network.SNSPacketHandler;
import mod.traister101.sns.network.ServerboundTogglePacket;
import mod.traister101.sns.util.ContainerType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ByIdMap;

public final class SNSUtils {
    public static final String ENABLED = "sns.enabled";
    public static final String DISABLED = "sns.disabled";

    public static void sendTogglePacket(ToggleType toggleType, boolean flag) {
        SNSPacketHandler.sendToServer(new ServerboundTogglePacket(flag, toggleType));
    }

    public static MutableComponent toggleTooltip(boolean flag) {
        return flag ? Component.m_237115_((String)ENABLED).m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)DISABLED).m_130940_(ChatFormatting.RED);
    }

    public static MutableComponent intComponent(int i) {
        return Component.m_237113_((String)String.valueOf(i));
    }

    private SNSUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum ToggleType {
        NONE(0, "", ""),
        VOID(1, "sns.status.sack.auto_void", "void"),
        PICKUP(2, "sns.status.sack.auto_pickup", "pickup");

        private static final IntFunction<ToggleType> BY_ID;
        public final int id;
        public final String langKey;
        public final String tag;

        private ToggleType(int id, String langKey, String tag) {
            this.id = id;
            this.langKey = langKey;
            this.tag = tag;
        }

        public static ToggleType byId(int toggleTypeId) {
            return BY_ID.apply(toggleTypeId);
        }

        public boolean supportsContainerType(ContainerType containerType) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> false;
                case VOID -> containerType.doesVoiding();
                case PICKUP -> containerType.doesAutoPickup();
            };
        }

        public MutableComponent getTooltip(boolean flag) {
            return Component.m_237110_((String)this.langKey, (Object[])new Object[]{SNSUtils.toggleTooltip(flag)});
        }

        public int getId() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.m_262839_(ToggleType::getId, (Object[])ToggleType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

